/* Trang web Đại Tạng Kinh được lập trình bởi Xuân Duật và đây là mã nguồn mở */

var scripts = [];
var requestID = undefined;

function obj(id) { return document.getElementById(id);}
function innerHTML(id, value) { obj(id).innerHTML = value;}
function show(id) { obj(id).style.display = 'block'; }
function hide(id) { obj(id).style.display = 'none'; }
function elementExist(id)
{
	var element = obj(id);
	return typeof(element) != 'undefined' && element != null;
}
function isMobile() {
  try{ document.createEvent("TouchEvent"); return true; }
  catch(e){ return false; }
}
function createStorage(name, value)
{
	if(typeof(Storage) !== 'undefined')
	{
		localStorage.setItem(name, value);
	}
}
function readStorage(name)
{
	if(typeof(Storage) !== 'undefined')
	{
		return localStorage.getItem(name);
	}
	return null;
}
function removeStorage(name)
{
	if(typeof(Storage) !== 'undefined')
	{
		localStorage.removeItem(name);
	}
}
function createCookie(name, value, days)
{
	if(days)
	{
		var date = new Date();
		date.setTime(date.getTime()+(days*24*60*60*1000));
		var expires = "; expires="+date.toGMTString();
	}
	else var expires = "";
	document.cookie = name+"="+value+expires+"; path=/";
}
function readCookie(name)
{
	var nameEQ = name + "=";
	var ca = document.cookie.split(';');
	for(var i=0; i < ca.length; i++)
	{
		var c = ca[i];
		while (c.charAt(0)==' ') c = c.substring(1,c.length);
		if (c.indexOf(nameEQ) == 0) return c.substring(nameEQ.length,c.length);
	}
	return null;
}
function selectText()
{
	return (document.all) ? document.selection.createRange().text : document.getSelection().toString();
}
function getPosition(element) 
{
    var xPosition = 0;
    var yPosition = 0;
      
    while (element) 
	{
        xPosition += (element.offsetLeft - element.scrollLeft + element.clientLeft);
        yPosition += (element.offsetTop - element.scrollTop + element.clientTop);
        element = element.offsetParent;
    }
    return { x: xPosition, y: yPosition };
}
function microtime()
{
	var d = new Date();
	return d.getTime(); 
}
function formatTime(s)
{
	if(isNaN(s) || s == 'undefined') return '';
	var hour  = Math.floor(s / 3600);
	var min = Math.floor((s - (hour * 3600))/60);
	var sec = Math.floor(s - (hour * 3600) -  (min * 60));

	if (hour){ if(hour < 10) hour = '0' + hour + ':';}
	else hour = '';
	if (min < 10) min = '0' + min;
	if (sec < 10) sec  = '0' + sec;
	return hour + min + ':' + sec;
}
function stopAnimation()
{
	if(requestID)
	{
		cancelAnimationFrame(requestID);
		requestID = undefined;
	}
}
function startAnimation(func){ requestID = requestAnimationFrame(func);}
function loadScript(src, callback)
{
	var callfunc = function()
	{
		eval(callback);
	}
	for(var i = 0; i < scripts.length; i++)
	{
		if(scripts[i] == src)
		{
			eval(callback);
			return;
		}
	}
    var head = document.getElementsByTagName('head')[0];
    var script = document.createElement('script');
    script.type = 'text/javascript';
    script.src = src;
    script.onreadystatechange = callfunc;
    script.onload = callfunc;
    head.appendChild(script);
	scripts.push(src);
}